/*
 * wol - send Magic Packet
 *
 * 1999-09-21 Kouichi Hirabayashi
 *
 * compiling
 *	cc -o wol wol.c
 *
 * This program is copy free and absolutely no warranty.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>

#define ETHERS			"/etc/ethers"

#define PORT_NO	7		/* echo */

static int sofd;
static struct sockaddr_in sv_addr, cl_addr;
static char bcaddr[32];		/* broad cast address */
static char macaddr[32];	/* MAC address */
static char ipaddr[32];		/* IP address */

static unsigned char stradr[6];
static unsigned int x[6];

int vflg;
static char *cmd;
char buf[BUFSIZ];

main(argc, argv) char **argv;
{
  char *s;
  int c, i, option;

  cmd = argv[0];
  while (--argc > 0 && (*++argv)[0] == '-')
	for (s = argv[0]+1; *s; s++)
		switch (c = *s) {
		case 'v':
			vflg++;
			break;
		default:
			Usage();
		}
  if (argc < 1)
	Usage();
  if (ismacadr(argv[0]))
	strcpy(macaddr, argv[0]);
  else
	getmacadr(argv[0]);
  if (argc > 1)
	strcpy(bcaddr, argv[1]);
  else
	getbcadr(argv[0]);

  if (!ismacadr(macaddr))
	error("Invalid MAC Address: %s", macaddr);
  sscanf(macaddr, "%x:%x:%x:%x:%x:%x",
	x, x+1, x+2, x+3, x+4, x+5);
  for (i = 0; i < 6; i++)
	stradr[i] = (unsigned char)x[i];

  if (vflg) {
	printf("Mac Address: %s\n", macaddr);
	printf("Broadcast Address: %s\n", bcaddr);
  }
  if ((sofd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	error("socket() failed.", (char *)0);
  option = 1;
  if (setsockopt(sofd, SOL_SOCKET, SO_BROADCAST,
		(void *)&option, sizeof(option)) < 0)
	error("setsockopt() failed.", (char *)0);

  bzero((char *)&cl_addr, sizeof(cl_addr));
  cl_addr.sin_family = AF_INET;
  cl_addr.sin_port = htons(0);
  cl_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  if (bind(sofd, (const struct sockaddr *)&cl_addr, sizeof(cl_addr)) < 0)
	error("bind() failed.", (char *)0);
  bzero((char *)&sv_addr, sizeof(sv_addr));
  sv_addr.sin_family = AF_INET;
  sv_addr.sin_port = htons(PORT_NO);
  sv_addr.sin_addr.s_addr = inet_addr(bcaddr);

  sendmagic();

  exit(0);
}

sendmagic()
{
  char *s, *t;
  int i, j;

  for (s = buf, i = 0; i < 6; i++)
	*s++ = 0xff;
  for (i = 0; i < 16; i++)
	for (t = (char *)stradr, j = 0; j < 6; j++)
		*s++ = t[j] & 0xff;
  if (sendto(sofd, buf, s - buf, 0, (const struct sockaddr *)&sv_addr, sizeof(sv_addr)) < 0)
	error("sendto() failed.", (char *)0);
  return 0;
}

getmacadr(host) char *host;
{
  FILE *fp;
  char *s, *t, *u;

  if ((fp = fopen(ETHERS, "r")) == NULL)
	error("can't open %s", ETHERS);
  while (fgets(buf, sizeof(buf), fp) != NULL) {
	if (*buf == '#')
		continue;
	for (s = buf; *s && *s != '\n'; s++)
		if (*s == ' ' || *s == '\t')
			break;
	u = s;
	while (*s == ' ' || *s == '\t')
		s++;
	for (t = host; *s == *t; s++, t++)
		;
	if (*t == '\0' && *s == '.' || *s == '\n' || *s == '\0') {
		for (s = buf, t = macaddr; s < u; )
			*t++ = *s++;
		*t = '\0';
		return 0;
	}
  }
  fprintf(stderr, "The hostname (%s) is not found in the /etc/ethers files.\n",
	host);
  exit(1);
}

getbcadr(host) char *host;
{
  struct hostent *shost;
  struct in_addr addr;
  int a, b, c, d;

  if ((shost = gethostbyname(host)) == NULL)
	error("gethostbyname(%s) failed", host);
  memcpy(&addr, shost->h_addr, shost->h_length);
  if (vflg)
	printf("IP Address: %s\n", inet_ntoa(addr));
  sscanf(inet_ntoa(addr), "%d.%d.%d.%d", &a, &b, &c, &d);
  if (!(a & 0x80))
	sprintf(bcaddr, "%d.255.255.255", a);
  else if ((a & 0xC0) == 0x80)
	sprintf(bcaddr, "%d.%d.255.255", a, b);
  else if ((a & 0xE0) == 0xC0)
	sprintf(bcaddr, "%d.%d.%d.255", a, b, c);
  return 0;
}

ismacadr(s) char *s;
{
  int i, j;

  for (i = 0; i < 6; i++, s++) {
	for (j = 0; j < 2; j++, s++)
		if (j == 1 && (*s == ':' || *s == '\0'))
			break;
		else if (strchr("0123456789AaBbCcDdEeFf", *s) == NULL)
			return 0;
	if (i < 5 && *s != ':')
		break;
	else if (i == 5 && *s == '\0')
		return 1;
  }
  return 0;
}

error(s, t) char *s, *t;
{
  fprintf(stderr, s, t);
  fprintf(stderr, "\n");
  exit(1);
}

Usage()
{
  static char *t[] = {
"Command	%s - send Magic Packet (WOL - Wake on LAN)",
"Syntax		%s [option] {MacAddress|HostName} [BroadcastAddress]",
"Option		-v	# print Mac Address and Broadcast Address",
"Examples	%s 00:20:ed:88:5c:f3 202.23.252.255",
"		%s host.my.domain 202.23.252.255",
"		%s host.my.domain",
"		%s host",
"Description	This program broadcasts the Magic Packet (Wake on LAN Packet)",
"to awake the specfied host.  If the HostName is specified by the first",
"argument it's MacAddress is determined by /etc/ethers database.  If the",
"BroadcastAddress is not specified, it is determined by the IP address of",
"the specified host.  You must specify the Subnet Directed Broadcast to",
"awake the remote host on other segment over routers.",
  NULL
  };
  int i;

  for (i = 0; t[i]; i++) {
	fprintf(stderr, t[i], cmd);
	fprintf(stderr, "\n");
  }
  exit(1);
} 
